/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1.charts;

import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.datamodels.v2_1.SampleData;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.DataRange;
import com.roguewave.chart.overlay.core.v2_1.DefaultNumericFormatter;
import com.roguewave.chart.overlay.core.v2_1.NumericFormatter;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.overlay.overlays.v2_1.BarChartOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.BinScaleOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.HighLowChartOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.LineChartOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.LinearGridOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.LinearScaleOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.Log10ScaleOverlay;
import com.roguewave.chart.overlay.overlays.v2_1.MarkerFactory;
import com.roguewave.chart.standard.v2_1.ChartLite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;

public class OverlayChart
extends Panel
implements ScaleConstants {
    private static final Font defaultLabelFont = new Font("TimesRoman", 0, 10);
    private com.roguewave.chart.overlay.core.v2_1.OverlayChart builder_ = new com.roguewave.chart.overlay.core.v2_1.OverlayChart();
    private ChartLite chart_;
    private DataModel data_;
    LinearGridOverlay grid_;
    BinScaleOverlay bscale_;
    int firstColumnLine_ = 4;
    int columnLinePeriod_ = 5;
    private int width_ = 2000;
    private int height_ = 300;

    public OverlayChart() {
        this(new SampleData());
    }

    public OverlayChart(DataModel data) {
        this.data_ = data;
        this.grid_ = new LinearGridOverlay(this.firstColumnLine_, this.columnLinePeriod_);
        this.builder_.addOverlay(this.grid_);
        this.bscale_ = new BinScaleOverlay(this.firstColumnLine_, this.columnLinePeriod_, Color.black, defaultLabelFont);
        this.builder_.addOverlay(this.bscale_);
        this.chart_ = new ChartLite(this.builder_, this.data_);
        this.chart_.setBackground(Color.white);
        this.chart_.setSize(this.width_, this.height_);
        this.setLayout(new BorderLayout());
        this.add("Center", this.chart_);
    }

    public boolean suspendUpdates(boolean flag) {
        return this.chart_.suspendUpdates(flag);
    }

    public ChartLite getListenerComponent() {
        return this.chart_;
    }

    protected com.roguewave.chart.overlay.core.v2_1.OverlayChart getOverlayChart() {
        return this.builder_;
    }

    public void addOverlay(ChartOverlay overlay) {
        this.builder_.addOverlay(overlay);
    }

    public void addGrid(int first, int period) {
        this.addOverlay(new LinearGridOverlay(first, period));
    }

    public void addScale(boolean scale) {
        this.addScale(scale, new DefaultNumericFormatter());
    }

    public void addScale(boolean scale, NumericFormatter formatter) {
        this.addScale(scale, formatter, scale ? this.getPrimaryColor() : this.getSecondaryColor(), defaultLabelFont, 0, 0);
    }

    public void addScale(boolean scale, NumericFormatter formatter, Color color, Font font, int lowLabelOffset, int highLabelOffset) {
        LinearScaleOverlay overlay = new LinearScaleOverlay(scale, formatter, color, font);
        overlay.setLowLabelOffset(lowLabelOffset);
        overlay.setHighLabelOffset(highLabelOffset);
        this.addOverlay(overlay);
    }

    public void addLog10Scale(boolean scale, NumericFormatter formatter) {
        Color color = scale ? this.getPrimaryColor() : this.getSecondaryColor();
        this.addLog10Scale(scale, formatter, color, defaultLabelFont, 0, 0);
    }

    public void addLog10Scale(boolean scale, NumericFormatter formatter, Color color, Font font, int lowLabelOffset, int highLabelOffset) {
        Log10ScaleOverlay overlay = new Log10ScaleOverlay(scale, formatter, color, font);
        overlay.setLowLabelOffset(lowLabelOffset);
        overlay.setHighLabelOffset(highLabelOffset);
        this.builder_.setLog10Scale(scale, true);
        this.addOverlay(overlay);
    }

    public void addBottomScale(int firstLabel, int labelPeriod) {
        this.addOverlay(new BinScaleOverlay(firstLabel, labelPeriod, Color.black, defaultLabelFont));
    }

    public void addBarChart(boolean scale, int row, int barWidth, Color color) {
        this.addOverlay(new BarChartOverlay(row, barWidth, color, scale));
    }

    public void addHighLowChart(boolean scale, int tickWidth, Color color) {
        this.addOverlay(new HighLowChartOverlay(tickWidth, color, scale));
    }

    public void addLineChart(boolean scale, int row, Color color, boolean skipMissing, MarkerFactory factory) {
        this.addOverlay(new LineChartOverlay(row, color, scale, skipMissing, factory));
    }

    public void setDataRange1(DataRange range) {
        this.builder_.setDataRange1(range);
    }

    public void setDataRange2(DataRange range) {
        this.builder_.setDataRange2(range);
    }

    public void setDataRangeLow1(double low) {
        this.builder_.setDataRangeLow1(low);
    }

    public void setDataRangeLow2(double low) {
        this.builder_.setDataRangeLow2(low);
    }

    public void setDataRangeHigh1(double high) {
        this.builder_.setDataRangeHigh1(high);
    }

    public void setDataRangeHigh2(double high) {
        this.builder_.setDataRangeHigh2(high);
    }

    public boolean getIgnorePrimaryAxis() {
        return this.builder_.getIgnorePrimaryAxis();
    }

    public void setIgnorePrimaryAxis(boolean ignore) {
        this.builder_.setIgnorePrimaryAxis(ignore);
    }

    public boolean getIgnoreSecondaryAxis() {
        return this.builder_.getIgnoreSecondaryAxis();
    }

    public void setIgnoreSecondaryAxis(boolean ignore) {
        this.builder_.setIgnoreSecondaryAxis(ignore);
    }

    protected void setOverlay(int i, ChartOverlay overlay) {
        this.builder_.setOverlay(i, overlay);
    }

    public Color getPrimaryColor() {
        return this.builder_.getPrimaryColor();
    }

    public void setPrimaryColor(Color color) {
        this.builder_.setPrimaryColor(color);
    }

    public double getScaleIncrement1() {
        return this.builder_.getScaleIncrement1(this.data_);
    }

    public void setScaleIncrement1(double increment) {
        this.builder_.setScaleIncrement1(increment);
    }

    public double getScaleIncrement2() {
        return this.builder_.getScaleIncrement2(this.data_);
    }

    public void setScaleIncrement2(double increment) {
        this.builder_.setScaleIncrement2(increment);
    }

    public Color getSecondaryColor() {
        return this.builder_.getSecondaryColor();
    }

    public void setSecondaryColor(Color color) {
        this.builder_.setSecondaryColor(color);
    }

    public void update() {
        this.chart_.update();
    }

    public DataModel getData() {
        return this.data_;
    }

    public void setData(DataModel data) {
        this.data_ = data;
        this.chart_.setData(this.data_);
    }

    public void setSize(int width, int height) {
        if (width == this.width_ && height == this.height_) {
            return;
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.width_ = width;
        this.height_ = height;
        this.builder_.setDrawHeight(height);
        this.chart_.setSize(width, height);
        this.chart_.update();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.setSize(w, h);
    }

    public int getBottomMargin() {
        return this.builder_.getBottomMargin();
    }

    public void setBottomMargin(int margin) {
        this.builder_.setBottomMargin(margin);
    }

    public int getColumnLinePeriod() {
        return this.columnLinePeriod_;
    }

    public void setColumnLinePeriod(int period) {
        if (period < 1) {
            return;
        }
        this.columnLinePeriod_ = period;
        this.grid_.setLinePeriod(this.columnLinePeriod_);
        this.bscale_.setLabelPeriod(this.columnLinePeriod_);
        this.chart_.update();
    }

    public int getFirstColumnLine() {
        return this.firstColumnLine_;
    }

    public void setFirstColumnLine(int first) {
        if (first < 0) {
            return;
        }
        this.firstColumnLine_ = first;
        this.grid_.setFirstLine(this.firstColumnLine_);
        this.bscale_.setFirstLabel(this.firstColumnLine_);
    }

    public int getLeftMargin() {
        return this.builder_.getLeftMargin();
    }

    public void setLeftMargin(int margin) {
        this.builder_.setLeftMargin(margin);
    }

    public int getSpaceWidth() {
        return this.builder_.getSpaceWidth();
    }

    public void setSpaceWidth(int width) {
        if (width < 0) {
            return;
        }
        this.builder_.setSpaceWidth(width);
        this.chart_.update();
    }

    public Font getTitleFont() {
        return this.builder_.getTitleFont();
    }

    public void setTitleFont(Font font) {
        this.builder_.setTitleFont(font);
    }

    public int getTitleMargin() {
        return this.builder_.getTitleMargin();
    }

    public void setTitleMargin(int margin) {
        this.builder_.setTitleMargin(margin);
    }

    public boolean getVerticalGridLines() {
        return this.grid_.getShowVerticalLines();
    }

    public void setVerticalGridLines(boolean flag) {
        this.grid_.setShowVerticalLines(flag);
        this.chart_.update();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.builder_.getLeftMargin() * 2 + this.builder_.getColumnWidth() * 2, this.builder_.getTitleMargin() + this.builder_.getBottomMargin() + 25);
    }

    protected void setDrawHeight(int height) {
        this.builder_.setDrawHeight(height);
    }

    protected void setChartComponentSize(int width, int height) {
        this.chart_.setSize(width, height);
    }

    protected int getColumnWidth() {
        return this.builder_.getColumnWidth();
    }

    protected double getScaleIncrement1(DataModel data) {
        return this.builder_.getScaleIncrement1(data);
    }

    protected double getScaleIncrement2(DataModel data) {
        return this.builder_.getScaleIncrement2(data);
    }
}

